/*
 * SPDX-FileCopyrightText: Nedko Arnaudov
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * VA38 GUI
 */
#include <stdio.h>
#include <unistd.h>		/* read() */
#include <errno.h>
#include "common.h"
#include "version.h"
#include "serial.h"
#include "decode.h"

struct mixer_app app;

int main(int argc, char ** argv)
{
    int ret = 1;
    FILE * out = stdout;
    bool help = false;
    bool gui = true;		/* try */
    int line_fd;

    if (argc != 2) { help = true; out = stderr; ret = 1; }

    fprintf(
        out,
        "VA38 GUI "PACKAGE_VERSION" ("GIT_VERSION")\n"
        );

    if (help)
    {
        fprintf(out, "Usage: va38-gui <ttydev>\n");
        fprintf(out, "<ttydev> specifies path to device file for usb-serial tty, e.g. /dev/ttyUSB0\n");
        goto exit;
    }

    if (!ui_init(&app))
    {
        fprintf(stderr, "Cannot initialize GUI.\n");
        gui = false;
    }

    line_fd = open_serial_line(argv[1]);
    if (line_fd < 0)
    {
        fprintf(stderr, "Cannot initialize communication via serial port.\n");
        goto deinit_ui;
    }

loop:
    if ((gui && nk_pugl_process_events(app.win_ptr, 1./25)) || true)
    {
        char buffer[4096];
        ssize_t sret = read(line_fd, buffer, sizeof(buffer));
        if (sret > 0)
        {
            decode_va38(buffer, (size_t)sret);
        }
        else if (errno != EAGAIN)
        {
            fprintf(stderr, "\nERROR%d\n", errno);
        }
        if (!gui) sleep(1);
        goto loop;
    }

    close(line_fd);

    ret = 0;

deinit_ui:
    if (gui) ui_deinit(&app);

exit:
    return ret;
}
