/*
 * SPDX-FileCopyrightText: Nedko Arnaudov
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * VA38 GUI
 */

#define NK_IMPLEMENTATION
#define NK_PUGL_CAIRO_IMPLEMENTATION
#define STB_IMAGE_IMPLEMENTATION

#include "common.h"

#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>
#include <libgen.h>

#include <X11/X.h>
#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

bool on_draw2_draw (cairo_t *cr);
void vumeter_redraw();

#define cr canvas
#define app_ptr ((struct mixer_app *)callback_data.ptr)

#if 0
static
void
on_nk_command_custom(
    void * canvas,
    short x,
    short y,
    unsigned short w,
    unsigned short h,
    nk_handle callback_data)
{
//    fprintf(stderr, "on_nk_command_custom(cr=%p, x=%hd y=%hd w=%hu h=%hu app_ptr=%p) called \n", cr, x, y, w, h, callback_data.ptr);
    vumeter_redraw();
    on_draw2_draw(cr);
}
#endif

/* draw a one inch high strip */
#if 0
static
void
on_nk_command_custom_one_inch_strip(
    void * canvas,
    short x,
    short y,
    unsigned short w,
    unsigned short h,
    nk_handle callback_data)
{
//	    NK_API void nk_stroke_rect(struct nk_command_buffer*, struct nk_rect, float rounding, float line_thickness, struct nk_color);
    r.x = 0;
    r.y = wbounds_ptr->w;
    r.w = w;
    r.h = round(app_ptr->ydpi);
}
#endif

#undef cr
#undef app_ptr

#define app_ptr ((struct mixer_app *)data)

static
void
on_nk_pugl_refresh(
    struct nk_context * ctx,
    struct nk_rect * wbounds_ptr,
    void * data)
{
//    static unsigned int refresh_count;
//    char buffer[1024];
//    struct nk_rect r;
//    double xdpi, ydpi;

//    refresh_count++;

//    app_ptr->dy = 20.f * app_ptr->scale;

    /* FIXME */
    ctx->style.window.spacing = nk_vec2(app_ptr->cfg.fontsize,app_ptr->cfg.fontsize);
    ctx->style.window.padding = nk_vec2(app_ptr->cfg.fontsize,app_ptr->cfg.fontsize);

    const char * window_name = "base";
    if (nk_begin(ctx, window_name, *wbounds_ptr, NK_WINDOW_NO_SCROLLBAR))
    {
        // custom widget pixel width
//        nk_layout_row_begin(ctx, NK_STATIC, app_ptr->cfg.fontsize * 1.2, 1);
        nk_layout_row_dynamic(ctx, wbounds_ptr->h/2, 2);
        {
//            nk_layout_row_push(ctx, min(app_ptr->background.w, 1280));
            nk_image(ctx, app_ptr->background);

//            nk_layout_row_push(ctx, min(app_ptr->background.w, 200));
//            nk_image(ctx, app_ptr->background);

#if 0
            struct nk_command_buffer* cmdbuf = nk_window_get_canvas(ctx);
            r.x = 10;
            r.y = 100;
            r.w = 100;
            r.h = 100;
            nk_push_custom(
                cmdbuf,
                r,
                on_nk_command_custom,
                nk_handle_ptr(app_ptr));
#endif

#if 0
            nk_layout_row_push(ctx, wbounds_ptr->w);
//            nk_slider_float(ctx, 0, &value, 1.0f, 0.1f);
            snprintf(buffer, sizeof(buffer), "Window refreshed %u times.", refresh_count);
            nk_label(ctx, buffer, NK_TEXT_LEFT);

            nk_layout_row_push(ctx, wbounds_ptr->w);
//	    xdpi = puglGetXDPI(app_ptr->win_ptr->view);
//	    ydpi = puglGetYDPI(app_ptr->win_ptr->view);
            snprintf(buffer, sizeof(buffer), "DPI %f x %f", app_ptr->xdpi, app_ptr->ydpi);
            nk_label(ctx, buffer, NK_TEXT_LEFT);
//            nk_layout_row_push(ctx, wbounds_ptr->w);
            nk_layout_row_push(ctx, wbounds_ptr->w);
            snprintf(buffer, sizeof(buffer), "Scale factor (vs 96 DPI) %f", app_ptr->scale);
            nk_label(ctx, buffer, NK_TEXT_LEFT);
            nk_layout_row_push(ctx, wbounds_ptr->w);
            snprintf(buffer, sizeof(buffer), "Pixel size %f x %f mm", 25.4 / app_ptr->xdpi, 25.4 / app_ptr->ydpi);
            nk_label(ctx, buffer, NK_TEXT_LEFT);
            snprintf(buffer, sizeof(buffer), "Font size %.1fpt (%.3fmm, %.3fpx)", app_ptr->fontsize_pt, app_ptr->fontsize_pt * 25.4 / 72.0, app_ptr->cfg.fontsize);
            nk_label(ctx, buffer, NK_TEXT_LEFT);
#endif
        }
//        nk_layout_row_end(ctx);

//	nk_layout_row_static(ctx, round(app_ptr->ydpi), wbounds_ptr->w, 1);
//	{
#if 0
            struct nk_command_buffer* cmdbuf = nk_window_get_canvas(ctx);
            r.x = 10;
            r.y = 100;
            r.w = 100;
            r.h = 100;
            nk_push_custom(
                cmdbuf,
                r,
                on_nk_command_custom,
                nk_handle_ptr(app_ptr));
#endif

#if 0
            nk_layout_row_push(ctx, wbounds_ptr->w);
	    struct nk_command_buffer *canvas = nk_window_get_canvas(ctx);
//	    const struct nk_rect old_clip = canvas->clip;
//	    struct nk_rect r;
//	    NK_API void nk_stroke_rect(struct nk_command_buffer*, struct nk_rect, float rounding, float line_thickness, struct nk_color);
            r.w = round(app_ptr->xdpi * 4);
            r.h = round(app_ptr->ydpi * 4);
            r.x = (wbounds_ptr->w - r.w) / 2;
            r.y = (wbounds_ptr->h - r.h) / 2;
	    nk_fill_rect(canvas, r, 1.0, nk_rgb(128,128,128));
	    nk_stroke_rect(canvas, r, 0.0, 1.0, nk_rgb(255,255,255));
	    const char * text = "101.6 x 101.6 mm";
	    const struct nk_user_font *font = ctx->style.font;
            //snprintf(buffer, sizeof(buffer), text);
//	    nk_push_scissor(canvas, r);
//	    nk_text_colored(ctx, text, strlen(text), NK_TEXT_CENTERED, nk_rgb(200,200,0));
	    struct nk_rect text_rect = r;
	    float font_height = app_ptr->cfg.fontsize;
	    float text_width = app_ptr->win_ptr->font.width(app_ptr->win_ptr->font.userdata, font_height, text, strlen(text));
	    float xofs = (text_rect.w - text_width) / 2;
	    float yofs = (text_rect.h - font_height) / 2;
	    text_rect.x += xofs;
	    text_rect.w -= xofs;
	    text_rect.y += yofs;
	    text_rect.h -= yofs;
//	    nk_push_font_size(ctx, 20);
	    nk_draw_text(canvas, text_rect, text, strlen(text), font, nk_rgb(128,128,128), nk_rgb(255,255,255));
//	    nk_push_scissor(canvas, old_clip);
//	    cairo_set_font_size((cairo_t *)canvas, 72);
//            nk_label_colored(ctx, buffer, NK_TEXT_CENTERED, nk_rgb(200,200,0));
//	    cairo_set_font_size((cairo_t *)canvas, app_ptr->cfg.fontsize);
#endif
//        }
//        nk_layout_row_end(ctx);
    }
    nk_end(ctx);
}

#undef app_ptr

#define app_ptr ((struct mixer_app *)timer_id)

static
void
on_nk_pugl_timer(
    uintptr_t timer_id)
{
//    fprintf(stderr, "on_nk_pugl_timer\n");
    nk_pugl_redisplay(app_ptr->win_ptr);
}

#undef app_ptr

static char *
_get_path(const char *data_dir, const char *fn)
{
    static char path [PATH_MAX];

    snprintf(path, sizeof(path), "%s%s", data_dir, fn);

    return path;
}

static const char *
_get_data_dir(void)
{
    char bin_path[PATH_MAX];

    // check whether build-time defined data dir exists
    DIR *dir = opendir(VA38GUI_DATA_DIR);
    if (dir)
    {
	closedir(dir);
	return VA38GUI_DATA_DIR;
    }

    // derive directory of executable
    if (readlink("/proc/self/exe", bin_path, sizeof(bin_path)) == -1)
    {
	return NULL;
    }

    char * base_path = dirname(bin_path);

    // derive data dir reative to executable
    static char rel_path[PATH_MAX];
    snprintf(rel_path, sizeof(rel_path), "%s/../share/va38-gui/", base_path);

    return rel_path;
}

static struct nk_image null_img;

struct nk_image
nk_pugl_image_load(
    nk_pugl_window_t * win,
    const char * filename)
{
    int w, h, n;
    uint8_t * data;

    if (!win->view) return null_img;

    data = stbi_load(filename, &w, &h, &n, 4);
    if (!data)
    {
	fprintf(stderr, "Loading of %s failed\n", filename);
	return null_img;
    }

//    fprintf(stderr, "n=%d\n", n);

#if 1
    uint32_t * pixel_ptr;
    for (int y = 0; y < h; y++)
    {
        for (int x = 0; x < w; x++)
        {
            pixel_ptr = (uint32_t *)data + y * w + x;
            uint32_t pixel = *pixel_ptr;

            /* ABGR */
            uint8_t a = (pixel >> 24) & 0xFF;
            uint8_t b = (pixel >> 16) & 0xFF;
            uint8_t g = (pixel >>  8) & 0xFF;
            uint8_t r = (pixel >>  0) & 0xFF;

#if 0
            r = 0;
            g = 0;
            b = 0x80;
            a = 0xFF;
#endif

            /* ARGB */
            pixel = a;
            pixel <<= 8;
            pixel |= r;
            pixel <<= 8;
            pixel |= g;
            pixel <<= 8;
            pixel |= b;

            *pixel_ptr = pixel;
        }
    }
#endif

//    memset(data, 0xFF, w * h * 4);

//    fprintf(stderr, "loaded %dx%d image from %s\n", w, h, filename);
    struct nk_image img = nk_image_ptr(data);
    img.w = w;
    img.h = h;
    img.region[0] = 0;          /* x */
    img.region[1] = 0;          /* y */
    img.region[2] = w;          /* w */
    img.region[3] = h;          /* x */
    return img;
}

void
nk_pugl_image_unload(
    nk_pugl_window_t * win,
    struct nk_image img)
{
    if (!win->view) return;

    if (img.handle.ptr)
    {
        stbi_image_free(img.handle.ptr);
    }
}

static
struct nk_image
image_load(
    struct mixer_app * app_ptr,
    const char * path)
{
    char * fullpath = strdup(_get_path(app_ptr->data_dir, path));
    if (fullpath == NULL) return null_img;
    struct nk_image img = nk_pugl_image_load(app_ptr->win_ptr, fullpath);
    free(fullpath);
    return img;
}

static void
image_unload(
    struct mixer_app * app,
    struct nk_image img)
{
    nk_pugl_image_unload(app->win_ptr, img);
}

static bool
init_DPI_and_scale_factor96(struct mixer_app * app_ptr)
{
  double            dpi = 96.0;
  int w, h, w_mm, h_mm;
  double xdpi, ydpi;
  int screen;

  Display* display = XOpenDisplay(NULL);
  if (display == NULL) return false;
  screen = DefaultScreen(display);

  w    = DisplayWidth(   display, screen);
  w_mm = DisplayWidthMM( display, screen);
  h    = DisplayHeight(  display, screen);
  h_mm = DisplayHeightMM(display, screen);

  if (w_mm > 0 && h_mm > 0)
  {
      xdpi = (w * 25.4) / w_mm;
      ydpi = (h * 25.4) / h_mm;
      dpi = (xdpi + ydpi) / 2;
  }
  else
  {
      xdpi = dpi;
      ydpi = dpi;
  }

  const char* const rms = XResourceManagerString(display);
  if (rms) {
    XrmDatabase db = XrmGetStringDatabase(rms);
    if (db) {
      XrmValue value = {0U, NULL};
      char*    type  = NULL;
      if (XrmGetResource(db, "Xft.dpi", "Xft.Dpi", &type, &value)) {
        if (!type || !strcmp(type, "String")) {
          char*        end    = NULL;
          const double xftDpi = strtod(value.addr, &end);
          if (xftDpi > 0.0 && xftDpi < HUGE_VAL) {
            dpi = xftDpi;
            xdpi = dpi;
            ydpi = dpi;
          }
        }
      }

      XrmDestroyDatabase(db);
    }
  }

  app_ptr->scale = dpi / 96.0;
  app_ptr->xdpi = xdpi;
  app_ptr->ydpi = ydpi;
  return true;
}

bool
ui_init(
    struct mixer_app * app_ptr)
{
    app_ptr->data_dir = _get_data_dir();
    if (app_ptr->data_dir == NULL) return false;

    app_ptr->fontsize_pt = 18;	/* 72pt font is one inch high (DPI should not matter) */

    if (!init_DPI_and_scale_factor96(app_ptr))
    {
        fprintf(stderr, "Cannot connect to X11 server\n");
        return false;
    }

    // UI
    nk_pugl_config_t * cfg_ptr = &app_ptr->cfg;
    cfg_ptr->width = 1280 * app_ptr->scale;
    cfg_ptr->height = 720 * app_ptr->scale;
    cfg_ptr->resizable = true;
    cfg_ptr->class = "VA38GUI";
    cfg_ptr->title = "VA38 GUI";
    cfg_ptr->parent = 0;
// single threaded app    cfg_ptr->threads = true;
    cfg_ptr->data = app_ptr;
    cfg_ptr->refresh_cb = on_nk_pugl_refresh;
//	cfg->expose = _expose;
    cfg_ptr->fontname = strdup(_get_path(app_ptr->data_dir, "Raleway-Bold.ttf"));
//	fprintf(stderr, "Font %s\n", cfg_ptr->fontname);
    cfg_ptr->fontsize = round(app_ptr->fontsize_pt * app_ptr->ydpi / 72.0); /* convert pt to pixels */
//    fprintf(stderr, "Font size %f\n", cfg_ptr->fontsize);

    app_ptr->win_ptr = nk_pugl_init(cfg_ptr);

    app_ptr->background = image_load(app_ptr, "va38-display.png");

    nk_pugl_show(app_ptr->win_ptr, nk_true);

    nk_pugl_set_timer_func(
        app_ptr->win_ptr,
        (uintptr_t)app_ptr,
        on_nk_pugl_timer,
        0.1);

    return true;
}

void
ui_deinit(
    struct mixer_app * app_ptr)
{
    image_unload(app_ptr, app_ptr->background);

    nk_pugl_show(app_ptr->win_ptr, nk_false);
    nk_pugl_shutdown(app_ptr->win_ptr);

    free((void *)app_ptr->cfg.fontname);
}
