/*
 * SPDX-FileCopyrightText: Nedko Arnaudov
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * VA38 GUI
 */

#ifndef COMMON_H__007DD87B_914A_48E4_84A2_C370A42B4CD8__INCLUDED
#define COMMON_H__007DD87B_914A_48E4_84A2_C370A42B4CD8__INCLUDED

#include "config.h"

#include <stdbool.h>
#include <assert.h>

#define NK_ASSERT(expr) assert(expr)

#include <nuklear/nuklear.h>
#include <nk_pugl_cairo/nk_pugl_cairo.h>
#include <stb/stb_image.h>

#define UNUSED(x) UNUSED_ ## x __attribute__((unused))

#define max(a,b)             \
({                           \
    __typeof__ (a) _a = (a); \
    __typeof__ (b) _b = (b); \
    _a > _b ? _a : _b;       \
})

#define min(a,b)             \
({                           \
    __typeof__ (a) _a = (a); \
    __typeof__ (b) _b = (b); \
    _a < _b ? _a : _b;       \
})

struct mixer_app
{
    nk_pugl_config_t cfg;
    nk_pugl_window_t * win_ptr;

    float xdpi;
    float ydpi;
    float scale;		/* vs 96dpi */
    float fontsize_pt;
//    float dy;

    const char * data_dir;
    struct nk_image background;
};

bool ui_init(struct mixer_app * app_ptr);
void ui_deinit(struct mixer_app * app_ptr);

#endif /* #ifndef COMMON_H__007DD87B_914A_48E4_84A2_C370A42B4CD8__INCLUDED */
