/*
 * SPDX-FileCopyrightText: Nedko Arnaudov
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * VA38 GUI
 */

#include <stdio.h>

void decode_va38(const char * buffer_ptr, size_t buffer_size)
{
    static char atom[8];
    static int atom_size = -1;
    while (buffer_size > 0)
    {
        //if ((*buffer_ptr & 0xF0) == 0xA0) fprintf(stderr, "\n"); else fprintf(stderr, " ");
        //fprintf(stderr, "%02X", *buffer_ptr);
        if ((*buffer_ptr & 0xF0) == 0xA0) atom_size = 0;
        if (atom_size >= 0 && atom_size < 8)
        {
            atom[atom_size] = *buffer_ptr;
            atom_size++;
        }
        if (atom_size == 8)
        {
            fprintf(stdout, "%02X %02X %02X %02X  %02X %02X %02X %02X | ", atom[0], atom[1], atom[2], atom[3], atom[4], atom[5], atom[6], atom[7]);
            const char * sign = (atom[2] & 0x20) ? "-" : " ";
            const char * unit = "";
            const char * factor = " ";
            switch (atom[1] & 0x1F)
            {
            case 0x00: unit = "V AC"; break;
            case 0x01: unit = "dBm"; break;
            case 0x02: unit = "V DC"; break;
            case 0x03: unit = "V AC/DC"; break;
            case 0x04: unit = "mV DC"; break;
            case 0x05: unit = "mV AC"; break;
            case 0x06: unit = "mV AC/DC"; break;
            case 0x07: unit = "Hz"; break;
            case 0x08: unit = "%"; break;
            case 0x09: unit = "V (diode)"; break;
            case 0x0A: unit = "Ω"; break;
            case 0x0B: unit = "Ω (cont)"; break;
            case 0x0C: unit = "(n)F"; break;
            case 0x0D: unit = "µA DC"; break;
            case 0x0E: unit = "µA AC"; break;
            case 0x0F: unit = "µA AC/DC"; break;
            case 0x10: unit = "mA DC"; break;
            case 0x11: unit = "mA AC"; break;
            case 0x12: unit = "mA AC/DC"; break;
            case 0x13: unit = "A DC"; break;
            case 0x14: unit = "A AC"; break;
            case 0x15: unit = "A AC/DC"; break;
            }

	    const char * dot0;
	    const char * dot1;
	    const char * dot2;
	    const char * dot3;
	    dot0 = dot1 = dot2 = dot3 = "";
            switch (atom[0] & 0x0F)
            {
            case 0x0: dot0 = "."; /* factor = "K"; */ break;
            case 0x1: dot1 = "."; /* factor = "K"; */ break;
            case 0x2: dot2 = "."; /* factor = "K"; */ break;
            case 0x3: dot3 = "."; /* factor = "K"; */ break;
            case 0x4: factor = "M"; break;
            case 0x5: factor = "G"; break;
            }
            if ((atom[1] & 0xF0) == 0x20)
            {
                fprintf(stdout, "  OL   %s%s\n", factor, unit);
            }
            else
            {
                unsigned int digit10k = atom[3] & 0x0F;
                unsigned int digit1k  = atom[4] & 0x0F;
                unsigned int digit100 = atom[5] & 0x0F;
                unsigned int digit10  = atom[6] & 0x0F;
                unsigned int digit1   = atom[7] & 0x0F;
                fprintf(stdout, "%s%d%s%d%s%d%s%d%s%d %s%s\n", sign, digit10k, dot0, digit1k, dot1, digit100, dot2, digit10, dot3, digit1, factor, unit);
            }
            /* unsigned int value = */
            /*     (atom[3] & 0x0F) * 10000 + */
            /*     (atom[4] & 0x0F) * 1000 + */
            /*     (atom[5] & 0x0F) * 100 + */
            /*     (atom[6] & 0x0F) * 10 + */
            /*     (atom[7] & 0x0F); */
//            fprintf(stdout, "%02X %02X %02X %02X  %02X %02X %02X %02X - %u\n", atom[0], atom[1], atom[2], atom[3], atom[4], atom[5], atom[6], atom[7], value);
            atom_size = -1;
        }
        buffer_ptr++; buffer_size--;
    }
}
