/* -*- Mode: C ; c-basic-offset: 2 -*- */
/*
 * SPDX-FileCopyrightText: Nedko Arnaudov
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * VA38 GUI
 */

#include <termios.h>
#include <string.h>		/* memcpy() */
#include <fcntl.h>
#include <unistd.h>
#include <err.h>
#include <sys/ioctl.h>

#include "serial.h"

int open_serial_line(const char * line)
{
    struct termios line_tio;
    struct termios tio;
    int line_fd;

    line_fd = open(line, O_RDWR | O_NONBLOCK);
    if (line_fd < 0)
    {
        warn("open(\"%s\")", line);
        return -1;
    }

    if (ioctl(line_fd, TIOCEXCL) != 0)
    {
        warn("ioctl(TIOCEXCL)");
	close(line_fd);
        return -1;
    }

    if (tcgetattr(line_fd, &line_tio) != 0)
    {
        warn("tcgetattr");
	close(line_fd);
        return -1;
    }

    memcpy(&tio, &line_tio, sizeof(tio));
    tio.c_iflag &= ~(ISTRIP|ICRNL);
    tio.c_oflag &= ~OPOST;
    tio.c_lflag &= ~(ICANON|ISIG|IEXTEN|ECHO);
    tio.c_cflag &= ~(CSIZE|PARENB);
    tio.c_cflag |= CREAD|CS8|CLOCAL;
    tio.c_cc[VMIN] = 1;
    tio.c_cc[VTIME] = 0;
    cfsetspeed(&tio, 2400);
    if (tcsetattr(line_fd, TCSAFLUSH, &tio) != 0)
    {
        warn("tcsetattr");
	close(line_fd);
	return -1;
    }

    return line_fd;
}
